--------------------------------------------------------------------------------------------------------------
--
-- Module     : SIMS Database SQL Server 2005
-- Platform   : SIMS
-- Area       : DBUpgrade Database Patch
-- Copyright  : (c) Capita Education Services 2005-2009
--            : This code has been written by Capita Education Services for use within its own SIMS systems.
--            : It is unpublished proprietary work, and as such it is illegal for it to be reproduced by any
--            : means or used without the express written permission of Capita Education Services.
-- Patch ID   : 26835
--
--------------------------------------------------------------------------------------------------------------

-- Check this is within the acceptible range
  IF NOT EXISTS(
	SELECT 1 
	FROM	sims.db_version_info
	WHERE	schema_version BETWEEN '3.63.879' AND '3.64.999')
  BEGIN
    DECLARE @error_msg2 VARCHAR(100)
    SET @error_msg2 = CHAR(10) + CHAR(13) + 'This patch is not applicable to this database version.' + CHAR(10) + CHAR(13)
	raiserror(@error_msg2, 18, 1)
  END

-- This is a RunOnce patch - check its not already been applied.
ELSE IF EXISTS(SELECT 1 
	        FROM   sims.db_update_log 
	        WHERE	patch_id = 26835)
  BEGIN
    DECLARE @error_msg1 VARCHAR(100)
    SET @error_msg1 = CHAR(10) + CHAR(13) + 'This patch has already been run on the database and cannot be run again.' + CHAR(10) + CHAR(13)
	raiserror(@error_msg1, 18, 1) 
  END

GO
-- START PATCH CODE



-- START PATCH SCRIPT 1

/*--------------------------------------------------------------------------------------------------------------*/
/* Module     : SIMS Database SQL Server 2012                                                                   */
/* Platform   : Pulsar                                                                                          */
/* Area       : Assessment      																			    */
/* Copyright  : LegalCopyright (c) Capita Children Services Ltd 1984-2020                                       */
/*            : This code has been written by Capita Children Services for use within its own SIMS systems.     */
/*            : It is unpublished proprietary work, and as such it is illegal for it to be reproduced by any    */
/*            : means or used without the express written permission of Capita Children Services.               */
/*                                                                                                              */
/* Format     : Transact-SQL                                                                                    */
/* Object     : Database upgrade script that would license HRAssistant within SIMS for GDST Core                */
/* Purpose    : This patch activates the  HRAssistant for Core, GDST functionality within SIMS                  */
/* Comments   :																								    */
/*                                                                                                              */
/* Author     : Partner Dev Support                                                                             */
/* Date       : Jan 2020                                                                                        */
/*--------------------------------------------------------------------------------------------------------------*/

-- License HRAssistant for SAM People - SIMS
if exists(select 1 from sims.db_process_class where process_name='HRAssistant')
begin
	exec sims.db_p_configure_processes @values = '<data><row ProcessName=''HRAssistant'' Licensed=''T'' ReadOnly =''0'' /></data>'   

	if exists(select 1 from sims.per_hra_configuration)
	begin
		delete from sims.per_hra_configuration
	end

	INSERT INTO sims.per_hra_configuration 
	( [Supplier],[Configuration]) VALUES ('SAM People', 
	'<Configuration>
  <KeyColour>Black</KeyColour>
  <AlternateColour>White</AlternateColour>
  <Title>SAM People </Title>
  <SaveFolder>SAM\SIMS\</SaveFolder>
  <Functions>
    <Button1>ExportStaff</Button1>
    <Button2>ExportLookups</Button2>
    <Button3></Button3>
    <Button4>ImportStaff</Button4>
    <Button5></Button5>
    <Button6>Exit</Button6>
  </Functions>
  <Customer>SAM People</Customer>
  <Exclude>
      <Field>
        <Name>MaritalStatus</Name>
      </Field>
      <Field>
        <Name>Religion</Name>
      </Field>
      <Field>
        <Name>Ethnicity</Name>
      </Field>
      <Field>
        <Name>StaffCode</Name>
      </Field>
      <Field>
        <Name>DisabilityNumber</Name>
    </Field>
    </Exclude>
</Configuration>')


end
go




-- END PATCH SCRIPT 1
GO


-- END PATCH CODE



-- Record that this patch has been updated
INSERT INTO sims.db_update_log
(
	patch_id,
	update_id,
	successful,
	description,
	update_type,
	date_applied
)
VALUES
(
	26835,
	1,
	'T',
	'SAMPeople HRAssistant license patch',
	'U',
	GetDate()
)

